/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.util.Map;
import java.util.Stack;
import panther.util.unicon.ArrayMap;

public class Timer {
    protected Map timings = new ArrayMap();
    protected long startTime = System.currentTimeMillis();
    protected Stack processStack = new Stack();

    public String toString() {
        return this.getTimings().toString();
    }

    public void start(String string) {
        if (!this.processStack.empty()) {
            this.addTime((String)this.processStack.peek());
        }
        this.processStack.push(string);
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        if (this.processStack.empty()) {
            throw new Error("Attempt to stop timer with empty process stack");
        }
        String string = (String)this.processStack.pop();
        this.addTime(string);
        this.startTime = System.currentTimeMillis();
    }

    public void stopAndStart(String string) {
        this.stop();
        this.start(string);
    }

    public Map getTimings() {
        return this.timings;
    }

    protected void addTime(String string) {
        long l = System.currentTimeMillis();
        long l2 = l - this.startTime;
        Long l3 = (Long)this.timings.get(string);
        long l4 = 0L;
        if (l3 != null) {
            l4 = l3;
        }
        this.timings.put(string, new Long(l4 += l2));
    }
}

